﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Configuration;
using System.Web;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;
using System.Net.Mail;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.WebUI
{
    public static class WebSession
    {
        static string siteDesc = ConfigurationManager.AppSettings["SiteDesc"].ToString();

        public static bool ApplyGST = ConfigurationManager.AppSettings["ApplyGST"].ToString().ToLower().Equals("true") ? true : false;

        public static bool ApplyRounding = ConfigurationManager.AppSettings["ApplyRoundTotal"].ToString().ToLower().Equals("true") ? true : false;

        public static bool ApplyServiceTax = ConfigurationManager.AppSettings["ApplyServiceTax"].ToString().ToLower().Equals("true") ? true : false;

        public static decimal RoundMarkup = Convert.ToDecimal(ConfigurationManager.AppSettings["RoundMarkup"].ToString());

        public static decimal ServiceTaxPercent = Convert.ToDecimal(ConfigurationManager.AppSettings["ServiceTaxPercent"].ToString());

        public static decimal GSTPercent = Convert.ToDecimal(ConfigurationManager.AppSettings["GSTPercent"].ToString());

        public static bool CurrentGSTSetting = ApplyGST;

        public static int PageNumber
        {
            get
            {
                if (HttpContext.Current.Session["PageNumber"] != null)
                    return (int)HttpContext.Current.Session["PageNumber"];
                else
                    return 0;
            }
            set
            {
                HttpContext.Current.Session["PageNumber"] = value;
            }
        }

        public static bool IsHappyHour
        {

            get
            {
                List<HappyHours> _happyHours = HappyHourPromoBL.GetList(Guid.Empty);
                if (_happyHours != null && _happyHours.Count > 0)
                {
                    _happyHours = _happyHours.Where(a => a.IsEnabled).ToList<HappyHours>();
                }
                _happyHours = _happyHours == null ? new List<HappyHours>() : _happyHours;
                return _happyHours.Where(a => a.StartTime.Hour <= DateTime.Now.Hour && DateTime.Now.Hour < a.EndTime.Hour).Any();
            }

            set { }
        }

        public static string GetUserIP()
        {
            try
            {
                string[] ipArray;
                HttpContext context = HttpContext.Current;
                string sIPAddress = context.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
                if (string.IsNullOrEmpty(sIPAddress))
                    sIPAddress = context.Request.ServerVariables["REMOTE_ADDR"].ToString();
                else
                {
                    ipArray = sIPAddress.Split(new char[] { ',' });
                    sIPAddress = ipArray[0].ToString();
                }

                return sIPAddress;
            }
            catch { return string.Empty; }
        }

        public static void RedirectToAdminDashBoard(bool isFromLogin)
        {
            if (WebSession.CurrentAdminUser == null) //If not logged in
            {
                //if (!isFromLogin)
                HttpContext.Current.Response.Redirect("~/Admin/Default.aspx", false);
            }
            else
            {
                if (isFromLogin)
                    HttpContext.Current.Response.Redirect("~/Admin/Dashboard.aspx", false);
            }
        }

        #region Session Variables
        public static UserAccount CurrentAdminUser
        {
            get
            {
                if (HttpContext.Current.Session["CurrentAdminUser"] != null)
                {
                    return (UserAccount)HttpContext.Current.Session["CurrentAdminUser"];
                }
                else
                {
                    return null;
                }
            }
            set
            {
                HttpContext.Current.Session["CurrentAdminUser"] = value;
            }
        }

        public static UserAccount CurrentUser
        {
            get
            {
                if (HttpContext.Current.Session["UserAccount"] != null)
                {
                    return (UserAccount)HttpContext.Current.Session["UserAccount"];
                }
                else
                {
                    return null;
                }
            }
            set
            {
                HttpContext.Current.Session["UserAccount"] = value;
            }
        }

        public static Orders CurrentOrders
        {
            get
            {
                if (HttpContext.Current.Session["CurrentOrders"] != null)
                {
                    return (Orders)HttpContext.Current.Session["CurrentOrders"];
                }
                else
                {
                    return null;
                }
            }
            set
            {
                HttpContext.Current.Session["CurrentOrders"] = value;
            }
        }

        public static Orders CurrentPOSOrders
        {
            get
            {
                if (HttpContext.Current.Session["CurrentPOSOrders"] != null)
                {
                    return (Orders)HttpContext.Current.Session["CurrentPOSOrders"];
                }
                else
                {
                    return null;
                }
            }
            set
            {
                HttpContext.Current.Session["CurrentPOSOrders"] = value;
            }
        }
        #endregion

        public static bool IsOrderFromQuotation
        {
            get
            {
                if (HttpContext.Current.Session["IsOrderFromQuotation"] != null)
                {
                    return (bool)HttpContext.Current.Session["IsOrderFromQuotation"];
                }
                else
                {
                    return false;
                }
            }
            set
            {
                HttpContext.Current.Session["IsOrderFromQuotation"] = value;
            }
        }

        public static List<ProductsXMeasurements> ProductsXMeasurementList
        {
            get
            {
                if (HttpContext.Current.Session["ProductsXMeasurementList"] != null)
                {
                    return (List<ProductsXMeasurements>)HttpContext.Current.Session["ProductsXMeasurementList"];
                }
                else
                {
                    return new List<ProductsXMeasurements>();
                }
            }
            set
            {
                HttpContext.Current.Session["ProductsXMeasurementList"] = value;
            }
        }



        public static void AddProductToCart(Orders currentOrder, Products currentProduct, decimal orderPrice, int qty, bool fromCart)
        {
            bool foundOrderItem = false;

            foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
            {
                if (od.ProductID == currentProduct.UniqueID)
                {
                    od.Quantity = (fromCart ? qty : (od.Quantity + qty));
                    od.OrderPrice = orderPrice;
                    od.DiscountValue = 0M;
                    od.DiscountType = string.Empty;
                    od.DiscountType = Constants.DISCOUNT_PERCENTAGE;
                    od.Amount = od.OrderPrice * od.Quantity;
                    if (od.Quantity <= 0)
                    {
                        RemoveProductFromCart(currentOrder, currentProduct.UniqueID);
                    }
                    foundOrderItem = true;
                    break;
                }
            }

            if (!foundOrderItem && qty > 0)
            {
                OrdersDetails ordItem = new OrdersDetails();
                ordItem.ProductID = currentProduct.UniqueID;
                ordItem.ProductName = currentProduct.ProductName;
                ordItem.UnitPrice = currentProduct.UnitPrice;
                ordItem.OrderPrice = orderPrice;
                ordItem.Quantity = qty;
                ordItem.Amount = (ordItem.OrderPrice * qty);
                ordItem.CanApplyDiscount = true;
                ordItem.EarliestAvailableDays = currentProduct.EarliestAvailableDays;
                currentOrder.OrdersDetailsList.Add(ordItem);
            }
        }

        public static void RemoveProductFromCart(Orders currentOrder, Guid currentProductID)
        {
            foreach (OrdersDetails oDetails in currentOrder.OrdersDetailsList)
            {
                if (oDetails.ProductID == currentProductID)
                {
                    currentOrder.OrdersDetailsList.Remove(oDetails);
                    break;
                }
            }
        }

        public static T GetConfigValue<T>(string Key)
        {
            T Val;
            string strVal = ConfigurationManager.AppSettings[Key].ToString();
            Val = (T) System.Convert.ChangeType(strVal, Type.GetTypeCode(typeof(T)));
            return Val;
        }

        public static void UpdateOrderProductQty(Orders currentOrder)
        {
            foreach (OrdersDetails od in currentOrder.OrdersDetailsList)
            {
                Products curProd = ProductsBL.GetItem(od.ProductID, string.Empty);
                if (curProd != null)
                {
                    if (!curProd.IsMiscellaneous)
                    {
                        curProd.Mode = GlobalConfigurations.Mode.Update;
                        if (curProd.ActualStock >= od.Quantity)
                        {
                            curProd.ActualStock = curProd.ActualStock - od.Quantity;
                        }
                        else
                        {
                            int qty = od.Quantity - curProd.ActualStock;
                            curProd.ActualStock = 0;
                            curProd.ReserveStock = curProd.ReserveStock - qty;
                        }
                        ProductsBL.Save(curProd);
                        if (curProd.ShareInventoryID != null && curProd.ShareInventoryID != Guid.Empty)
                        {
                            Entities.Products AliasProduct = ProductsBL.GetItem(curProd.ShareInventoryID, string.Empty);
                            AliasProduct.ActualStock = curProd.ActualStock;
                            AliasProduct.ReserveStock = curProd.ReserveStock;
                            ProductsBL.Save(AliasProduct);
                        }
                        curProd = ProductsBL.GetItem(curProd.UniqueID, string.Empty);
                        if ((curProd.ActualStock + curProd.ReserveStock) <= curProd.LowStockIndication)
                        {
                            WebSession.SendProductStockEmail(curProd);
                        }
                    }
                }
            }
        }

        #region Configuration Settings
        public static string SiteDesc
        {
            get
            {
                return ConfigurationManager.AppSettings["SiteDesc"].ToString();
            }
        }

        public static string SiteURL
        {
            get
            {
                return ConfigurationManager.AppSettings["SiteURL"].ToString();
            }
        }

        public static string PaypalURL
        {
            get
            {
                return ConfigurationManager.AppSettings["PaypalURL"].ToString();
            }
        }

        public static string PaypalMerchantID
        {
            get
            {
                return ConfigurationManager.AppSettings["PaypalMerchantID"].ToString();
            }
        }

        public static string AsiaPayURL
        {
            get
            {
                return ConfigurationManager.AppSettings["AsiaPayURL"].ToString();
            }
        }

        public static string AsiaPayMerchantID
        {
            get
            {
                return ConfigurationManager.AppSettings["AsiaPayMerchantID"].ToString();
            }
        }

        public static string DHLSiteID
        {
            get
            {
                return ConfigurationManager.AppSettings["DHLSiteID"].ToString();
            }
        }

        public static string DHLAccountNo
        {
            get
            {
                return ConfigurationManager.AppSettings["DHLAccountNo"].ToString();
            }
        }

        public static string DHLPassword
        {
            get
            {
                return ConfigurationManager.AppSettings["DHLPassword"].ToString();
            }
        }

        public static string DHLAPIURL
        {
            get
            {
                return ConfigurationManager.AppSettings["DHLAPIURL"].ToString();
            }
        }

        public static string OrdersFrom
        {
            get
            {
                return ConfigurationManager.AppSettings["OrdersFrom"].ToString();
            }
        }
        public static Guid SettingsID
        {
            get
            {
                return Guid.Parse(ConfigurationManager.AppSettings["SettingsID"].ToString());
            }
        }
        #endregion

        #region Email

        public static void SendSignUpEmail(UserAccount myUser)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "Welcome to AZVIC";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear " + myUser.FirstName + " " + myUser.LastName + @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>
                                            Thank you for joining AZVIC!
                                        </p>
                                        <p>
                                            As part of our Member, you’ll be getting a special treatment!
                                        </p>
                                        <p>
                                            We’ll make sure you are the first to know of our new arrivals and special offers. 
                                            In addition, enjoy Free Shipping for Orders above $350, special discount on your Birthday month, and other members only exclusive offers.
                                        </p>
                                        <p>
                                            GOOD THINGS ARE MEANT TO BE SHARED 
                                        </p>
                                        <p>
                                            On a final note, we have an AZVIC Guarantee policy. Click <a href=""" + siteDesc + @""" style=""text-decoration: none;"">here</a> to know more.
                                        </p>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, myUser.UniqueID);

            SendEmail(subject, clientBodyMessage, string.Empty, myUser.Email, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendSignUpEmailToAdmin(UserAccount myUser)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "New " + myUser.CustomerType + " Registration";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear Admin</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>
                                            The below user registered as " + myUser.CustomerType + @".Please approve this customer through CMS.
                                        </p>
                                        <p>
                                            First Name : <strong>" + myUser.FirstName + @"</strong><br>
                                            Last Name : <strong>" + myUser.LastName + @"</strong><br>
                                            User Name : <strong>" + myUser.UserName + @"</strong><br>
                                            Email : <strong>" + myUser.Email + @"</strong><br>
                                            Occupation : <strong>" + myUser.CustomerType + @"</strong>
                                        </p>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, myUser.UniqueID);

            SendEmail(subject, clientBodyMessage, string.Empty, string.Empty, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendForgotPasswordEmail(UserAccount myUser, string newPassword)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC Account Details";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear " + myUser.FirstName + " " + myUser.LastName + @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Your account information for AZVIC website is</p>
                                        <p style=""line-height: 25px; font-family: 'Arial', 'sans-serif';font-size: 13px;"">
                                            User Name : <strong>" + myUser.UserName + @"</strong><br>
                                            Password : <strong>" + newPassword + @"</strong>
                                        </p>
                                        <p>Please let us know if you have further difficulty to logging in</p>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, myUser.UniqueID);

            SendEmail(subject, clientBodyMessage, string.Empty, myUser.Email, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendQuickReply(string Name, string EmailID, string Subject, string EmailBody)
        {
            #region Email Body Content
            string clientBodyMessage = "";
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear " + Name + @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">" + EmailBody +
                                    @"</td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(false, Guid.Empty);

            SendEmail(Subject, EmailBody, string.Empty, EmailID, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendNewsLetterEmail(NewsLetters myLetter, UserAccount myUser)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = myLetter.EmailSubject;

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear " + myUser.FirstName + " " + myUser.LastName + @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">" + myLetter.EmailMessage +
                                    @"</td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, myUser.UniqueID);

            SendEmail(subject, clientBodyMessage, string.Empty, myUser.Email, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendOrderInfoEmail(Orders currentOrder)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC Order Details";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear " + currentOrder.FirstName + " " + currentOrder.LastName + @"</p>
                                        <p>
                                            Thank you for your purchase!
                                        </p>
                                        <p style=""margin-top: 20px; line-height: 20px; font-family: 'Arial', 'sans-serif';"">
                                            Your Order No. is <strong>" + currentOrder.OrderNumber + "</strong>. The following is a summary of your order." +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p><strong>Order No: </strong>" + currentOrder.OrderNumber + "<br><strong>Order Date: </strong>" + currentOrder.CreatedDate.ToString("dd/MM/yyyy") +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                            <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                <th style=""font-family: 'Arial', 'sans-serif';width:5px;"">
                                                    SLNO
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    DESCRIPTION
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    QTY
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    UNITPRICE
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    AMOUNT
                                                </th>
                                            </tr>";

            foreach (OrdersDetails item in currentOrder.OrdersDetailsList)
            {
                clientBodyMessage += @"<tr>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + (currentOrder.OrdersDetailsList.IndexOf(item) + 1).ToString() +
                                            @"</td>
                                            <td style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">" +
                                                item.ProductName +
                                            @"</td>
                                            <td style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Quantity.ToString() +
                                            @"</td>
                                            <td align=""center"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                + item.OrderPrice.ToString("0.00") +
                                            @"</td>
                                            <td align=""right"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Amount.ToString("0.00") +
                                            @"</td>
                                        </tr>";
            }
            clientBodyMessage += @"<tr>
                                        <td colspan=""5"" align=""right"" style=""font-family: 'Arial', 'sans-serif'; border: 1px solid #ccc;"">
                                            <table>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Subtotal:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentOrder.SubTotal.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Discount:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentOrder.Discount.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Shipping:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentOrder.Shipping.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Total Before GST:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentOrder.TotalBeforeGST.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">GST (7%):</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentOrder.GST.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Total:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentOrder.Total.ToString("0.00") + @"</td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>                     
                        <tr>
                            <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                    <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            BILLING ADDRESS
                                        </th>
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            SHIPPING ADDRESS
                                        </th>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.FirstName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.FirstName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.LastName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.LastName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingAddress1 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingAddress1 +
                                        @"</td>
                                    </tr>" + (currentOrder.BillingAddress2.Trim().Length != 0 || currentOrder.ShippingAddress2.Trim().Length != 0 ? @"
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingAddress2 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingAddress2 +
                                        @"</td>
                                    </tr>" : string.Empty) +
                                    @"<tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingCity +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingCity +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingState +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingState +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingCountry +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingCountry +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingPostalCode +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingPostalCode +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.BillingMobile +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.ShippingMobile +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.Email +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentOrder.Email +
                                        @"</td>
                                    </tr>
                                </table>
                                <table style=""font-family: 'Arial', 'sans-serif';border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                    <tr>
                                        <td style=""font-family: 'Arial', 'sans-serif';border: 1px solid #ccc; width: 100%;"">
                                            <strong>Delivery Date: </strong>" + currentOrder.EarliestAvailableDate.ToString("dd/MM/yyyy") +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""font-family: 'Arial', 'sans-serif';border: 1px solid #ccc; width: 100%;"">
                                            <strong>Urgent Delivery: </strong>" + (currentOrder.IsUrgentDelivery ? "Yes" : " No") +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""font-family: 'Arial', 'sans-serif';border: 1px solid #ccc; width: 100%;"">
                                            <strong>Comments: </strong>" + currentOrder.Comments +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""font-family: 'Arial', 'sans-serif';border: 1px solid #ccc; width: 100%;"">
                                            <strong>Payment Method: </strong>" + currentOrder.PaymentMethod +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""font-family: 'Arial', 'sans-serif';border: 1px solid #ccc; width: 100%;"">
                                            <strong>Payment Status: </strong>" + currentOrder.PaymentStatus +
                                        @"</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, currentOrder.UsersAccountID);

            SendEmail(subject, clientBodyMessage, string.Empty, currentOrder.Email, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendQuotationRequestToAdmin(Quotations currentQuotation)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC - New Quotation Request - " + currentQuotation.QuotationsNumber;

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear Admin</p>
                                        <p>
                                            New Quotation request from customer.
                                        </p>
                                        <p style=""margin-top: 20px; line-height: 20px; font-family: 'Arial', 'sans-serif';"">
                                            Quotation No. is <strong>" + currentQuotation.QuotationsNumber + "</strong>. The following is a summary of the Quotation." +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p><strong>Quotation No: </strong>" + currentQuotation.QuotationsNumber + "<br><strong>Quotation Date: </strong>" + currentQuotation.CreatedDate.ToString("dd/MM/yyyy") +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                            <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                <th style=""font-family: 'Arial', 'sans-serif';width:5px;"">
                                                    SLNO
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    DESCRIPTION
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    QTY
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    UNITPRICE
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    AMOUNT
                                                </th>
                                            </tr>";

            foreach (QuotationsDetails item in currentQuotation.QuotationsDetailsList)
            {
                Products curProd = ProductsBL.GetItem(item.ProductID, string.Empty);
                clientBodyMessage += @"<tr>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + (currentQuotation.QuotationsDetailsList.IndexOf(item) + 1).ToString() +
                                            @"</td>
                                            <td valign=""top"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">" +
                                                item.ProductName +
                                            @"  <br><img src=""" + siteDesc + "Images/ProductsImages/" + (curProd.Image1.Trim().Length != 0 ? curProd.Image1.Trim() : "No-Image1.png") + @""" alt="""" border=""0"" width=""100px"" height=""100px"" />
                                            </td>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Quantity.ToString() +
                                            @"</td>
                                            <td valign=""top"" align=""center"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                + item.OrderPrice.ToString("0.00") +
                                            @"</td>
                                            <td valign=""top"" align=""right"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Amount.ToString("0.00") +
                                            @"</td>
                                        </tr>";
            }
            clientBodyMessage += @"</table>
                            </td>
                        </tr>                     
                        <tr>
                            <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                    <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            BILLING ADDRESS
                                        </th>
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            SHIPPING ADDRESS
                                        </th>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.FirstName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.FirstName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.LastName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.LastName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingAddress1 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingAddress1 +
                                        @"</td>
                                    </tr>" + (currentQuotation.BillingAddress2.Trim().Length != 0 || currentQuotation.ShippingAddress2.Trim().Length != 0 ? @"
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingAddress2 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingAddress2 +
                                        @"</td>
                                    </tr>" : string.Empty) +
                                    @"<tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingCity +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingCity +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingState +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingState +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingCountry +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingCountry +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingPostalCode +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingPostalCode +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingMobile +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingMobile +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.Email +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.Email +
                                        @"</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(false, Guid.Empty);

            SendEmail(subject, clientBodyMessage, currentQuotation.Email, string.Empty, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendQuotationDetailsToCustomer(Quotations currentQuotation)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC - Quotation Request Details- " + currentQuotation.QuotationsNumber;

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                         <p>Dear " + currentQuotation.FirstName + " " + currentQuotation.LastName + @"</p>
                                        <p>
                                            Thank you for your interest!
                                        </p>
                                        <p style=""margin-top: 20px; line-height: 20px; font-family: 'Arial', 'sans-serif';"">
                                           Your Quotation No. is <strong>" + currentQuotation.QuotationsNumber + "</strong>. The following is a summary of the Quotation." +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p><strong>Quotation No: </strong>" + currentQuotation.QuotationsNumber + "<br><strong>Quotation Date: </strong>" + currentQuotation.CreatedDate.ToString("dd/MM/yyyy") +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                            <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                <th style=""font-family: 'Arial', 'sans-serif';width:5px;"">
                                                    SLNO
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    DESCRIPTION
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    QTY
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    UNITPRICE
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    AMOUNT
                                                </th>
                                            </tr>";

            foreach (QuotationsDetails item in currentQuotation.QuotationsDetailsList)
            {
                Products curProd = ProductsBL.GetItem(item.ProductID, string.Empty);
                clientBodyMessage += @"<tr>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + (currentQuotation.QuotationsDetailsList.IndexOf(item) + 1).ToString() +
                                            @"</td>
                                            <td valign=""top"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">" +
                                                item.ProductName +
                                            @"  <br><img src=""" + siteDesc + "Images/ProductsImages/" + (curProd.Image1.Trim().Length != 0 ? curProd.Image1.Trim() : "No-Image1.png") + @""" alt="""" border=""0"" width=""100px"" height=""100px"" />
                                            </td>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Quantity.ToString() +
                                            @"</td>
                                            <td valign=""top"" align=""center"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                + item.OrderPrice.ToString("0.00") +
                                            @"</td>
                                            <td valign=""top"" align=""right"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Amount.ToString("0.00") +
                                            @"</td>
                                        </tr>";
            }
            clientBodyMessage += @"</table>
                            </td>
                        </tr>                     
                        <tr>
                            <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                    <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            BILLING ADDRESS
                                        </th>
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            SHIPPING ADDRESS
                                        </th>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.FirstName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.FirstName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.LastName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.LastName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingAddress1 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingAddress1 +
                                        @"</td>
                                    </tr>" + (currentQuotation.BillingAddress2.Trim().Length != 0 || currentQuotation.ShippingAddress2.Trim().Length != 0 ? @"
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingAddress2 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingAddress2 +
                                        @"</td>
                                    </tr>" : string.Empty) +
                                    @"<tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingCity +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingCity +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingState +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingState +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingCountry +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingCountry +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingPostalCode +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingPostalCode +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingMobile +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingMobile +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.Email +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.Email +
                                        @"</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, currentQuotation.UsersAccountID);

            SendEmail(subject, clientBodyMessage, string.Empty, currentQuotation.Email, new string[] { }, new string[] { }, true, true, true);
        }


        public static void SendQuotationToPaymentEmail(Quotations currentQuotation)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC Quotation Details";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear " + currentQuotation.FirstName + " " + currentQuotation.LastName + @"</p>
                                        <p>
                                            Thank you for your Quotation request!
                                        </p>
                                        <p style=""margin-top: 20px; line-height: 20px; font-family: 'Arial', 'sans-serif';"">
                                            Your Quotation No. is <strong>" + currentQuotation.QuotationsNumber + "</strong>. The following is a summary of your Quotation." +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p><strong>Quotation No: </strong>" + currentQuotation.QuotationsNumber +
                                            "<br><strong>Quotation Date: </strong>" + currentQuotation.CreatedDate.ToString("dd/MM/yyyy") +
                                            "<br><strong>Expiry Date: </strong>" + currentQuotation.ExpiryDate.ToString("dd/MM/yyyy") +
                                        @"</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                            <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                <th style=""font-family: 'Arial', 'sans-serif';width:5px;"">
                                                    SLNO
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    DESCRIPTION
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    QTY
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    UNITPRICE
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    AMOUNT
                                                </th>
                                            </tr>";

            foreach (QuotationsDetails item in currentQuotation.QuotationsDetailsList)
            {
                Products curProd = ProductsBL.GetItem(item.ProductID, string.Empty);
                clientBodyMessage += @"<tr>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + (currentQuotation.QuotationsDetailsList.IndexOf(item) + 1).ToString() +
                                            @"</td>
                                            <td valign=""top"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">" +
                                                item.ProductName +
                                            @"  <br><img src=""" + siteDesc + "Images/ProductsImages/" + (curProd.Image1.Trim().Length != 0 ? curProd.Image1.Trim() : "No-Image1.png") + @""" alt="""" border=""0"" width=""100px"" height=""100px"" />
                                            </td>
                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                + item.Quantity.ToString() +
                                            @"</td>
                                            <td valign=""top"" align=""center"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';color:#FA2121;"">"
                                                + item.OrderPrice.ToString("0.00 (New Price)") +
                                            @"</td>
                                            <td valign=""top"" align=""right"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';color:#FA2121;"">"
                                                + item.Amount.ToString("0.00") +
                                            @"</td>
                                        </tr>";
            }
            clientBodyMessage += @"<tr>
                                        <td colspan=""5"" align=""right"" style=""font-family: 'Arial', 'sans-serif'; border: 1px solid #ccc;"">
                                            <table>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Subtotal:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentQuotation.SubTotal.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Discount:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentQuotation.Discount.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Shipping:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentQuotation.Shipping.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Total Before GST:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentQuotation.TotalBeforeGST.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">GST (7%):</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentQuotation.GST.ToString("0.00") + @"</td>
                                                </tr>
                                                <tr>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">Total:</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">SGD</td>
                                                    <td align=""right"" style=""font-family: 'Arial', 'sans-serif';font-size: 13px;"">" + currentQuotation.Total.ToString("0.00") + @"</td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>                     
                        <tr>
                            <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                    <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            BILLING ADDRESS
                                        </th>
                                        <th style=""font-family: 'Arial', 'sans-serif'; width: 50%;"" colspan=""2"">
                                            SHIPPING ADDRESS
                                        </th>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.FirstName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            First Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.FirstName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.LastName +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Last Name:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.LastName +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingAddress1 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Address:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingAddress1 +
                                        @"</td>
                                    </tr>" + (currentQuotation.BillingAddress2.Trim().Length != 0 || currentQuotation.ShippingAddress2.Trim().Length != 0 ? @"
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingAddress2 +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingAddress2 +
                                        @"</td>
                                    </tr>" : string.Empty) +
                                    @"<tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingCity +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            City:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingCity +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingState +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            State:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingState +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingCountry +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Country:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingCountry +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingPostalCode +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 12%;font-family: 'Arial', 'sans-serif';"">
                                            Postal Code:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 38%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingPostalCode +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.BillingMobile +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Mobile:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.ShippingMobile +
                                        @"</td>
                                    </tr>
                                    <tr>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.Email +
                                        @"</td>
                                        <td style=""border: 1px solid #ccc; width: 10%;font-family: 'Arial', 'sans-serif';"">
                                            Email:
                                        </td>
                                        <td style=""border: 1px solid #ccc; width: 40%;font-family: 'Arial', 'sans-serif';"">" + currentQuotation.Email +
                                        @"</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td align=""left"" style=""padding-top:20px;"">
                               Please click <a href=""" + siteDesc + "ProcessQuotationToPayment.aspx?UniqueID=" + currentQuotation.UniqueID.ToString() + @""">here</a> to proceed payment.
                            </td>
                        </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(true, currentQuotation.UsersAccountID);

            SendEmail(subject, clientBodyMessage, string.Empty, currentQuotation.Email, new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendProductStockEmail(Products currentProd)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC - Product Stock";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear Admin</p>
                                        <p>
                                            The below product is going the reach out of stock.
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                            <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                <th style=""font-family: 'Arial', 'sans-serif';width:5px;"">
                                                    SLNO
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    PRODUCT NAME
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                   ACTUAL QTY
                                                </th>
                                                <th style=""font-family: 'Arial', 'sans-serif';"">
                                                    RESERVE QTY
                                                </th>
                                            </tr>
                                            <tr>
                                                <td valign=""top"" style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">1</td>
                                                <td style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">" +
                                                    currentProd.ProductName +
                                                @"</td>
                                                <td style=""border: 1px solid #ccc; text-align: center; font-family: 'Arial', 'sans-serif';"">"
                                                    + currentProd.ActualStock.ToString() +
                                                @"</td>
                                                <td align=""center"" style=""border: 1px solid #ccc; font-family: 'Arial', 'sans-serif';"">"
                                                    + currentProd.ReserveStock.ToString() +
                                                @"</td>
                                          </tr>
                                        </table>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(false, Guid.Empty);

            SendEmail(subject, clientBodyMessage, string.Empty, ConfigurationManager.AppSettings["FromEmailAddress"].ToString(), new string[] { }, new string[] { }, true, true, true);
        }

        public static void SendProductCustomizationEmail(Products currentProd, string fullName, string email, string message)
        {
            string subject, clientBodyMessage;
            subject = clientBodyMessage = string.Empty;

            subject = "AZVIC - Product Customization";

            #region Email Body Content
            clientBodyMessage += @"<tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>Dear Admin</p>
                                        <p>
                                            The below request is from customer for customization of a product.
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                        <p>
                                            <table width=""100%"">
                                                <tr>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; width: 150px; border: 1px solid #ccc;"">
                                                        Full Name :
                                                    </td>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; border: 1px solid #ccc;"">" +
                                                        fullName +
                                                    @"</td>
                                                </tr>
                                                <tr>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; width: 150px; border: 1px solid #ccc;"">
                                                        Email :
                                                    </td>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; border: 1px solid #ccc;"">" +
                                                        email +
                                                    @"</td>
                                                </tr>
                                                <tr>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; width: 150px; border: 1px solid #ccc;"">
                                                        Message :
                                                    </td>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; border: 1px solid #ccc;"">" +
                                                        message +
                                                    @"</td>
                                                </tr>
                                                <tr>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; width: 150px; border: 1px solid #ccc;"">
                                                        Product Details:
                                                    </td>
                                                    <td style=""font-family: 'Arial', 'sans-serif'; border: 1px solid #ccc;"">"
                                                        + currentProd.ProductName +
                                                    @"</td>
                                              </tr>
                                            </table>
                                        </p>
                                    </td>
                                </tr>";
            #endregion

            clientBodyMessage = EmailHeader() + clientBodyMessage + EmailFooter(false, Guid.Empty);

            SendEmail(subject, clientBodyMessage, email, ConfigurationManager.AppSettings["FromEmailAddress"].ToString(), new string[] { }, new string[] { }, true, true, true);
        }

        public static string EmailHeader()
        {
            string header = string.Empty;

            header = @"<html lang=""en"" xmlns=""http://www.w3.org/1999/xhtml"">
                        <head><title></title></head>
                        <body style=""font-family: 'Arial', 'sans-serif'; font-size: 15px; padding: 0; margin: 0;"">
                            <table width=""740"" cellspacing=""0"" cellpadding=""0"" align=""center"" style=""padding: 5px 3px 5px 10px;"">
                                <tr>
                                    <td align=""left"">
                                        <img src=""" + siteDesc + "EmailImages/logo.jpg" + @""" alt="""" border=""0"" width=""150px"" height=""150px"" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <hr style=""margin-bottom: 20px;"" />
                                    </td>
                                </tr>";

            return header;
        }

        public static string EmailFooter(bool addCustomerInfo, Guid userAccountID)
        {
            string footer;

            footer = @"<tr>
                        <td style=""font-family: 'Arial', 'sans-serif';"">
                            <div style=""font-family: 'Arial', 'sans-serif'; margin-top: 30px; font-size: 15px;"">
                                Yours sincerely,<br />
                                AZVIC
                            </div>
                            <div style=""font-family: 'Arial', 'sans-serif'; margin-top: 30px; font-size: 12px; text-align: center; color: #fff; background-color: #4d4d4d;line-height:20px;"">
                                Visit <a href=""" + siteDesc + @""" style=""color: #fff; text-decoration: none;"">azvic.com</a> 
                                | " + ((addCustomerInfo && userAccountID != Guid.Empty) ? @"<a href=""" + siteDesc + @"MyProfile.aspx?UniqueID=" + userAccountID.ToString() + @""" style=""color: #fff; text-decoration: none;"">Update Your Information</a> | " : string.Empty)
                                   +
                                @"<a href=""" + siteDesc + @""" style=""color: #fff; text-decoration: none;"">Contact Us</a> 
                                |
                                <a href=""" + siteDesc + @""" style=""color: #fff; text-decoration: none;"">Facebook</a><br>
                                © " + DateTime.Now.Year.ToString() + @" azvic.com. All Rights Reserved.
                            </div>
                            <div style=""font-family: 'Arial', 'sans-serif'; margin-top: 10px; font-size: 10px; text-align: left;"">
                                Disclaimer: This message (and any attachments) may contain information that is confidential, proprietary, 
                                privileged or otherwise protected by law. The message is intended solely for the named addressee (or a person responsible for delivering it to the addressee). 
                                If you are not the intended recipient of the message or if you have received this message in error, 
                                please delete it from your system and notify us immediately at <a href=""mailto:admin@azvic.com"" style=""color: #4d4d4d; text-decoration: none;"">admin@azvic.com</a>.
                            </div>
                        </td>
                     </tr>
                    </table>
                   </body>
                  </html>";

            return footer;
        }

        public static void SendEmail(string emailSubject, string emailMessage, string fromEmail, string toEmail, string[] ccList, string[] bccList, bool isBodyHtml, bool sendToCC, bool sendToBCC)
        {
            try
            {
                SmtpClient client = new SmtpClient(ConfigurationManager.AppSettings["SmtpServer"], 25);
                client.Credentials = new System.Net.NetworkCredential(ConfigurationManager.AppSettings["FromEmailAddress"], ConfigurationManager.AppSettings["smtppassword"]);
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                MailMessage msg = new MailMessage();
                msg.IsBodyHtml = isBodyHtml;
                msg.Subject = emailSubject;
                msg.Body = emailMessage;
                try
                {
                    if (fromEmail.Trim().Length != 0)
                        msg.From = new MailAddress(fromEmail.Trim());
                    else
                        msg.From = new MailAddress(ConfigurationManager.AppSettings["FromEmailAddress"].ToString());
                    if (toEmail.Trim().Length != 0)
                        msg.To.Add(new MailAddress(toEmail));
                    else
                        msg.To.Add(new MailAddress(ConfigurationManager.AppSettings["ToEmailAddress"].ToString()));
                }
                catch { }

                //CC List From Code
                foreach (string cc in ccList)
                {
                    try
                    {
                        msg.CC.Add(cc);
                    }
                    catch { }
                }

                //CC List from Web.config
                if (sendToCC)
                {
                    string[] existingCClist = ConfigurationManager.AppSettings["CCEmailAddress"].Split(new char[] { ';' });
                    foreach (string cc in existingCClist)
                    {
                        if (cc.Trim().Length != 0)
                        {
                            try
                            {
                                msg.CC.Add(cc);
                            }
                            catch { }
                        }
                    }
                }


                //BCC List From Code
                foreach (string bcc in bccList)
                {
                    try
                    {
                        msg.Bcc.Add(bcc);
                    }
                    catch { }
                }
                //BCC List from web.config
                if (sendToBCC)
                {
                    string[] existingBCCList = ConfigurationManager.AppSettings["BCCEmailAddress"].Split(new char[] { ';' });
                    foreach (string bcc in existingBCCList)
                    {
                        if (bcc.Trim().Length != 0)
                        {
                            try
                            {
                                msg.Bcc.Add(bcc);
                            }
                            catch { }
                        }
                    }
                }

                client.Send(msg);
            }
            catch { }
        }

        public static void SendEmail(MailMessage message)
        {
            SmtpClient client = new SmtpClient(ConfigurationManager.AppSettings["SmtpServer"], 25);
            client.Credentials = new System.Net.NetworkCredential(ConfigurationManager.AppSettings["FromEmailAddress"], ConfigurationManager.AppSettings["smtppassword"]);
            client.Send(message);
        }
        #endregion
    }
}